#include "General.h"
#include "RestoreWeaponsCharacterOnJoin.h"
#include "HashTemplateClass.h"
#include "HashTemplateIterator.h"
#include "PhysicalGameObj.h"
#include "ArmedGameObj.h"
#include "weaponmgr.h"
#include "engine_weap.h"
#include "WeaponBagClass.h"
#include "WeaponClass.h"
#include "PowerupGameObjDef.h"
#include "DefinitionMgrClass.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

#define STYLE_BEACON 6
#define PowerupDefID 0x3003

struct WeaponCharacterData
{
	bool IsBeaconUsedUp; // Check if the beacon the guy had before leaving was used or not
	StringClass CharacterPreset; // The preset of the character that the guy had before he left
	StringClass BeaconPreset; // We need to give the beacon as a special case
	DynamicVectorClass<StringClass> WeaponList; // Weapons the guy had before he left
};

HashTemplateClass<StringClass, StringClass> PowerupTable; // Key is weapon name, value is powerup
HashTemplateClass<StringClass, WeaponCharacterData*> DataTable;


 void Load_Powerup_Table()
{
	for (PowerUpGameObjDef *Def = (PowerUpGameObjDef*)DefinitionMgrClass::Get_First(PowerupDefID);Def;Def = (PowerUpGameObjDef*)DefinitionMgrClass::Get_Next(Def,PowerupDefID)) 
	{
		if (Def->GrantWeapon)
		{
			WeaponDefinitionClass* WeaponDef = (WeaponDefinitionClass*)DefinitionMgrClass::Find_Definition(Def->GrantWeaponID, false);
			{
				if (WeaponDef)
				{
//					Console_Output("%s = %s\n", WeaponDef->Get_Name(), Def->Get_Name()); // DEBUG CRAP
					PowerupTable.Insert(WeaponDef->Get_Name(), Def->Get_Name());
				}
			}
		}
	}
}

RestoreWeaponsCharacterOnJoin::RestoreWeaponsCharacterOnJoin()
{
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	RegisterEvent(EVENT_GAME_OVER_HOOK,this);
	RegisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
}

RestoreWeaponsCharacterOnJoin::~RestoreWeaponsCharacterOnJoin()
{
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	UnregisterEvent(EVENT_GAME_OVER_HOOK,this);
	UnregisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
}

void RestoreWeaponsCharacterOnJoin::OnObjectCreate(void *data,GameObject *obj)
{
	if ( Commands->Is_A_Star(obj) )
	{
		StringClass Name = Get_Wide_Player_Name(obj);
		WeaponCharacterData *Data = DataTable.Get(Name, NULL);

		if (Data)
		{
			DataTable.Remove(Name); // first we remove the entry in the hash table or the fds will keep looping
			Change_Character(obj, Data->CharacterPreset); 

			int Count = Data->WeaponList.Count();

			for (int i = 0; i < Count; i++)
			{
				StringClass Powerup = PowerupTable.Get(Data->WeaponList[i], "ERR");
				if (Powerup == "ERR") { continue; }
				Commands->Give_PowerUp(obj, Powerup, false);
//				Console_Output("WeaponList[%d] = %s\n", i, Data->WeaponList[i]); // DEBUG CRAP
			}

			if ( !Data->BeaconPreset.Is_Empty() && !Data->IsBeaconUsedUp) 
			{
				StringClass BeaconPowerup = PowerupTable.Get(Data->BeaconPreset, "ERR");
				if (BeaconPowerup != "ERR") { Commands->Give_PowerUp(obj, BeaconPowerup, false); }			
			}
		
			Data->WeaponList.Delete_All();
			
			delete Data;		
		} 
	} 
}

bool FirstLoad = true;

void RestoreWeaponsCharacterOnJoin::OnLoadLevel()
{
	if (FirstLoad == true)
	{
		FirstLoad = false;

		Load_Powerup_Table();
	}
}

void RestoreWeaponsCharacterOnJoin::OnGameOver()
{
	for (HashTemplateIterator<StringClass, WeaponCharacterData*> iter(DataTable); iter; ++iter)
	{
		iter.getValue()->WeaponList.Delete_All();
		delete iter.getValue();
	}
}

void RestoreWeaponsCharacterOnJoin::OnPlayerLeave(int PlayerID)
{
	GameObject *obj = Get_GameObj(PlayerID);
	if ( Commands->Get_Health(obj) == 0.0f) { return; }

	WeaponCharacterData *Data = new WeaponCharacterData;
	Data->CharacterPreset = Commands->Get_Preset_Name(obj);
	Data->IsBeaconUsedUp = true;

	WeaponBagClass *w = obj->As_PhysicalGameObj()->As_ArmedGameObj()->Get_Weapon_Bag();
	int x = w->Get_Count();

	for (int i = 0;i < x;i++)
	{
		if (w->Peek_Weapon(i))
		{
			WeaponClass *wc = w->Peek_Weapon(i);

			if (wc->Get_Style() == STYLE_BEACON)
			{
				Data->IsBeaconUsedUp = true;

				if (wc->Get_Clip_Rounds() != 0)
				{				
					Data->IsBeaconUsedUp = false;
					Data->BeaconPreset = wc->Get_Name();
					
				}
				continue;
			}
			Data->WeaponList.Add(wc->Get_Name());
		}
	}
	
	StringClass Name = Get_Wide_Player_Name(obj);
	DataTable.Insert(Name, Data);
}

RestoreWeaponsCharacterOnJoin restoreWeaponsCharacterOnJoin;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &restoreWeaponsCharacterOnJoin;
}
